﻿#include <iostream>
#include <algorithm>
#include <math.h>
#include <cmath>
#include <vector>
#include <set>
#include <map>
#include <cmath>
#include <iomanip>
#include <cassert>
#define all(a) a.begin(), a.end()
#define int long long

using namespace std;
typedef long long ll;
typedef long double db;

template<typename T>
istream& operator>>(istream& in, vector<T>& v) {
	for (auto& u : v) in >> u;
	return in;
}

template<typename T1, typename T2>
istream& operator>>(istream& in, pair<T1, T2>& p) {
	in >> p.first >> p.second;
	return in;
}

const int mod = 998244353;

int power(int a, int b) {
	if (b == 0) return 1;
	if (b % 2 == 0) {
		int r = power(a, b / 2);
		return r * r % mod;
	}
	return power(a, b - 1) * a % mod;
}

int inv(int q) {
	return power(q, mod - 2);
}

vector<vector<int>> dp;

void solve() {
	int n, m; cin >> n >> m;
	dp.assign(n + 1, vector<int>(n + 1, 0));
	dp[0][0] = 1;
	for (int j = 1; j <= n; ++j) {
		dp[j][0] = 1;
		for (int i = 1; i <= n; ++i) {
			if (j > i) {
				dp[j][i] = dp[j - 1][i];
				continue;
			}
			dp[j][i] = dp[j][i - 1] * m - (i > j ? dp[j][i - j - 1]: 0) * (i == j + 1 ? m: m - 1);
			dp[j][i] = (dp[j][i] % mod + mod) % mod;
		}
	}
	int p = 0, q = 1;
	for (int j = 1; j <= n; ++j) {
		p += (dp[j][n] - dp[j - 1][n]) * j;
		p = (p % mod + mod) % mod;
		q *= m;
		q %= mod;
	}
	cout << p * inv(q) % mod << '\n';
}

signed main() {
	ios_base::sync_with_stdio(false); cin.tie(nullptr);
	int t; cin >> t;
	while (t--) solve();
}